<?php
/**
 * lifescore functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package lifescore
 */

if ( ! defined( '_S_VERSION' ) ) {
	// Replace the version number of the theme on each release.
	define( '_S_VERSION', '1.0.0' );
}

/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function lifescore_setup() {
	/*
		* Make theme available for translation.
		* Translations can be filed in the /languages/ directory.
		* If you're building a theme based on lifescore, use a find and replace
		* to change 'lifescore' to the name of your theme in all the template files.
		*/
	load_theme_textdomain( 'lifescore', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
		* Let WordPress manage the document title.
		* By adding theme support, we declare that this theme does not use a
		* hard-coded <title> tag in the document head, and expect WordPress to
		* provide it for us.
		*/
	add_theme_support( 'title-tag' );

	/*
		* Enable support for Post Thumbnails on posts and pages.
		*
		* @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		*/
	add_theme_support( 'post-thumbnails' );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus(
		array(
			'menu-1' => esc_html__( 'Primary', 'lifescore' ),
		)
	);

	/*
		* Switch default core markup for search form, comment form, and comments
		* to output valid HTML5.
		*/
	add_theme_support(
		'html5',
		array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
			'style',
			'script',
		)
	);

	// Set up the WordPress core custom background feature.
	add_theme_support(
		'custom-background',
		apply_filters(
			'lifescore_custom_background_args',
			array(
				'default-color' => 'ffffff',
				'default-image' => '',
			)
		)
	);

	// Add theme support for selective refresh for widgets.
	add_theme_support( 'customize-selective-refresh-widgets' );

	/**
	 * Add support for core custom logo.
	 *
	 * @link https://codex.wordpress.org/Theme_Logo
	 */
	add_theme_support(
		'custom-logo',
		array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		)
	);
}
add_action( 'after_setup_theme', 'lifescore_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function lifescore_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'lifescore_content_width', 640 );
}
add_action( 'after_setup_theme', 'lifescore_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function lifescore_widgets_init() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Sidebar', 'lifescore' ),
			'id'            => 'sidebar-1',
			'description'   => esc_html__( 'Add widgets here.', 'lifescore' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
}
add_action( 'widgets_init', 'lifescore_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function lifescore_scripts() {
	wp_enqueue_style( 'lifescore-style', get_stylesheet_uri(), array(), _S_VERSION );
	wp_style_add_data( 'lifescore-style', 'rtl', 'replace' );

	wp_enqueue_script( 'lifescore-navigation', get_template_directory_uri() . '/js/navigation.js', array(), _S_VERSION, true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'lifescore_scripts' );

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require get_template_directory() . '/inc/jetpack.php';
}

function wooc_extra_register_fields() {?>

	<p class="form-row form-row-first">
	<label for="reg_billing_first_name"><?php _e( 'Full name', 'woocommerce' ); ?><span class="required">*</span></label>
	<input type="text" required class="input-text" name="billing_first_name" id="reg_billing_first_name" value="<?php if ( ! empty( $_POST['billing_first_name'] ) ) esc_attr_e( $_POST['billing_first_name'] ); ?>" />
	</p>

	<div class="clear"></div>
	<?php
}
add_action( 'woocommerce_register_form_start', 'wooc_extra_register_fields' );

add_action('admin_menu', 'survey_list');

function survey_list()
{
    add_menu_page(
        'Survey Listing',     // page title
        'Survey Listing',     // menu title
        'manage_options',   // capability
        'survey-listing',     // menu slug
        'survey_list_render' // callback function
    );
}

function survey_list_render()
{
    global $title;

    print '<div class="clear"></div><div class="wrap">';
    /*print "<h1>$title</h1>";*/

    $file = plugin_dir_path( __FILE__ ) . "template_survey_list_admin.php";

    if ( file_exists( $file ) )
        require $file;

    print '</div>';
}

//Filter Code - Swatantra Bhargava - 15-05-2024
add_action('wp_ajax_filter_survey_list', 'filter_survey_list');
add_action('wp_ajax_nopriv_filter_survey_list', 'filter_survey_list');

function filter_survey_list() {

	global $wpdb;

	$user_d = $_POST['user_dtls'];

	// Make string searchable
	$user_nicename = str_replace(" ", "-", $user_d);
	$display_name = str_replace(" ", "-", $user_d);
	
	$start_date = $_POST['start_date'];
    $end_date = $_POST['end_date'];
    
	$query = "SELECT * FROM wp_survey INNER JOIN wp_users ON wp_survey.user_id = wp_users.ID WHERE 1";
	
	if(!empty($start_date) && !empty($end_date)) {
		$start_date .= " 00:00:00";
		$end_date .= " 23:59:59";
		$query .= " AND created_at >= '".$start_date."' AND created_at <= '".$end_date."'";
	}

	if(!empty($user_d)) {
		$query .= " AND (user_nicename LIKE('".$user_nicename."%') OR display_name LIKE('".$display_name."%'))";
	}

	$result = $wpdb->get_results( $query.' ORDER BY survey_id DESC ' );

    if($result) {
        foreach($result as $index => $survey){ 
			$uData = get_userdata( $survey->user_id );
			$full_name = esc_attr( $uData->first_name ) . " " . esc_attr( $uData->last_name );
			$result = $wpdb->get_results(sprintf('SELECT * FROM wp_survey WHERE survey_id=' . $survey->survey_id));
			$total_question = $result[0]->total_question * 10;


			$data = json_decode($result[0]->data);
			$cat = array();
			$chcked = array();
			$allpoint = 0;

			foreach ($data as $datas) {
				$res = explode('-', $datas);
				$cat[] = $res[0];
				$value = $res[3];
				$k = $res[0];
				$chcked[$k][] = $value;
				$allpoint = $allpoint + $value;
			}

			$percentageAll = round(($allpoint * 100 / $total_question));
			
			$survey_date = date('F j, Y', strtotime($survey->created_at));
            // Display filtered posts
            ?>
				<tr>
				   <td><span><?php echo $full_name; ?></span></td>
				   <td><span><?php echo $survey_date; ?></span></td>
				   <td><span><?php echo $percentageAll; ?>%</span></td>
				   <td>
					<ul class="action-table">
						<li> <a href="/result?surveyid=<?php echo $survey->survey_id ?>"> <i class="fa fa-eye" aria-hidden="true"></i> </a> </li>
					</ul>
				   </td>
			   </tr>
            <?php
			}
		}
    else {
        echo '<tr><td colspan="4">No record found.</td></tr>';
    }
    die();
}

// Add custom fields to WooCommerce registration form
function custom_woocommerce_registration_fields() {
    ?>
    <p class="form-row form-row-wide">
        <label for="reg_gender"><?php _e( 'Gender', 'woocommerce' ); ?> <span class="required">*</span></label>
        <select name="gender" id="reg_gender" class="input-select" required>
            <option value=""><?php _e( 'Select a gender', 'woocommerce' ); ?></option>
            <option value="male"><?php _e( 'Male', 'woocommerce' ); ?></option>
            <option value="female"><?php _e( 'Female', 'woocommerce' ); ?></option>
            <option value="other"><?php _e( 'Other', 'woocommerce' ); ?></option>
        </select>
    </p>
    <p class="form-row form-row-wide">
        <label for="reg_age"><?php _e( 'Age', 'woocommerce' ); ?> <span class="required">*</span></label>
        <input type="number" class="input-text" name="age" id="reg_age" required maxlength="2" />
    </p>
    <?php
}
add_action( 'woocommerce_register_form_start', 'custom_woocommerce_registration_fields' );

// Validate custom fields
function custom_woocommerce_validate_fields( $username, $email, $validation_errors ) {
    if ( isset( $_POST['gender'] ) && empty( $_POST['gender'] ) ) {
        $validation_errors->add( 'gender_error', __( 'Gender is a required field.', 'woocommerce' ) );
    }
    if ( isset( $_POST['age'] ) && empty( $_POST['age'] ) ) {
        $validation_errors->add( 'age_error', __( 'Age is a required field.', 'woocommerce' ) );
    }
    return $validation_errors;
}
add_action( 'woocommerce_register_post', 'custom_woocommerce_validate_fields', 10, 3 );

// Save custom fields
function custom_woocommerce_save_fields( $customer_id ) {
    if ( isset( $_POST['gender'] ) ) {
        update_user_meta( $customer_id, 'gender', sanitize_text_field( $_POST['gender'] ) );
    }
    if ( isset( $_POST['age'] ) ) {
        update_user_meta( $customer_id, 'age', sanitize_text_field( $_POST['age'] ) );
    }
}
add_action( 'woocommerce_created_customer', 'custom_woocommerce_save_fields' );

// Add fields to edit account page
function custom_woocommerce_edit_account_fields( $user ) {
	
	$current_user = wp_get_current_user(); //get_currentuserinfo();
	$user_id = $current_user->ID;

	$all_meta_for_user = get_user_meta( $user_id );

    $gender = $all_meta_for_user["gender"][0]; //get_user_meta( $user_id, 'gender', true );
    $age = $all_meta_for_user["age"][0]; //get_user_meta( $user_id, 'age', true );
    ?>
    <p class="woocommerce-form-row woocommerce-form-row--first form-row form-row-first">
        <label for="account_gender"><?php esc_html_e( 'Gender', 'woocommerce' ); ?></label>
        <select name="account_gender" id="account_gender" class="input-select">
            <option value=""><?php _e( 'Select a gender', 'woocommerce' ); ?></option>
            <option value="male" <?php selected( $gender, 'male' ); ?>><?php _e( 'Male', 'woocommerce' ); ?></option>
            <option value="female" <?php selected( $gender, 'female' ); ?>><?php _e( 'Female', 'woocommerce' ); ?></option>
            <option value="other" <?php selected( $gender, 'other' ); ?>><?php _e( 'Other', 'woocommerce' ); ?></option>
        </select>
    </p>
    <p class="woocommerce-form-row woocommerce-form-row--last form-row form-row-last">
        <label for="account_age"><?php _e( 'Age', 'woocommerce' ); ?></label>
        <input type="number" class="input-text" name="account_age" id="account_age" value="<?php echo esc_attr( $age ); ?>" maxlength="2" />
    </p>
	<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">&nbsp;</p>
    <?php
}
add_action( 'woocommerce_edit_account_form', 'custom_woocommerce_edit_account_fields' );

// Save custom fields from edit account page
function custom_woocommerce_save_account_fields( $user_id ) {
	
    if ( isset( $_POST['account_gender'] ) ) {
        update_user_meta( $user_id, 'gender', sanitize_text_field( $_POST['account_gender'] ) );
    }
    if ( isset( $_POST['account_age'] ) ) {
        update_user_meta( $user_id, 'age', sanitize_text_field( $_POST['account_age'] ) );
    }
}
add_action( 'woocommerce_save_account_details', 'custom_woocommerce_save_account_fields' );


// function create_blogs_post_type() {
//     register_post_type('blogs',
//         array(
//             'labels' => array(
//                 'name' => __('Blogs'),
//                 'singular_name' => __('Blog')
//             ),
//             'public' => true,
//             'has_archive' => true,
//             'rewrite' => array('slug' => 'blogs'),
//             'supports' => array('title', 'editor', 'thumbnail')
//         )
//     );
// }
// add_action('init', 'create_blogs_post_type');
